//***************************************************************************
//
//  PROGRAM   : BNDEMO3.CPP
//
//  PROGRAMMER: Steven R Clabaugh
//              SRC Enterprises
//
//  PURPOSE   : Bare-bones Windows MFC application used to demonstrate
//              Button Control Class.
//              Does not use a VIEW class or a DOCUMENT class.
//
//***************************************************************************
#include <afxwin.h>
#include <srcentbn.h>
#include "resource.h"
#include "bndemo3.h"

//***************************************************************************
//***************************************************************************
// Implementation for the application class 'CTheApp'
//***************************************************************************
//***************************************************************************

//***************************************************************************
//
//  Application Class 'InitApplication' member function
//
//***************************************************************************
BOOL CTheApp::InitApplication()
{

   // The reason we register a window class is to provide the ability to set
   // the client area to the color of our choice.
   // The class name is returned in the application class m_ClassName
   // data member and passed to the CMainWnd class's contructor within the
   // InitInstance function.
   m_WndClassName = AfxRegisterWndClass(
                       NULL,                               // Class Style
                       LoadStandardCursor(IDC_ARROW),      // Cursor
                       CreateSolidBrush(RGB(192,192,192)), // Client Area Color
                       LoadIcon(AFX_IDI_STD_FRAME)         // Application Icon
                 );

   return TRUE;

} // End CTheApp::InitApplication

//***************************************************************************
//
//  Application Class 'InitInstance' member function
//
//  Creates and shows the main window
//
//***************************************************************************
BOOL CTheApp::InitInstance()
{

   //  Declare the Application's Main Window object
   //    and call its constructor
   m_pMainWnd = new CMainWnd(m_WndClassName);

   // Make the window visable; Update its client area; return successfull
   m_pMainWnd->ShowWindow(m_nCmdShow);   // Show the window
   m_pMainWnd->UpdateWindow();           // Sends WM_PAINT Msg
   return TRUE;

} // End CTheApp::InitInstance

//**** End Application Class Implementation *********************************
//***************************************************************************
//***************************************************************************

//***************************************************************************
//***************************************************************************
// Implementation for the application's Main Window class 'CMainWnd'
//***************************************************************************
//***************************************************************************

//***************************************************************************
//
//  CMainWnd Class Constructor
//
//***************************************************************************
CMainWnd::CMainWnd(CString WndClassName)
{

   // Create the Main Window
   Create(WndClassName,                  // Window Class Name
          AfxGetAppName(),               // Text for Window Title Bar
          WS_OVERLAPPEDWINDOW,           // Window Style
          CRect(10,10,425,280),          // Window Position and Size
          NULL,                          // Overlapped Windows have no Parent
          "MAINMENU",                    // Main Menu Resource Name
          0,                             // No Extened style attributes
          NULL                           // Pointer Not Needed
         );

   cBuff = "         ";
   TextColor = RGB(0,0,0);  // Init to Black
   
} // End CMainWnd::CMainWnd Class Constructor

//***************************************************************************
//
//  Create the message map for the main window procedure
//
//***************************************************************************
BEGIN_MESSAGE_MAP(CMainWnd, CFrameWnd)
   //{{AFX_MSG_MAP(CMainWnd)
   ON_COMMAND(ID_APP_ABOUT,OnAbout)
   ON_COMMAND(IDBN_VSPIN1,OnVSpin1)
   ON_COMMAND(IDBN_VSPIN2,OnVSpin2)
   ON_COMMAND(IDBN_VSPIN3,OnVSpin3)
   ON_COMMAND(IDBN_VSPIN4,OnVSpin4)
   ON_COMMAND(IDBN_VSPIN5,OnVSpin5)
   ON_COMMAND(IDBN_VSPIN6,OnVSpin6)
   ON_COMMAND(IDBN_HSPIN1,OnHSpin1)
   ON_COMMAND(IDBN_HSPIN2,OnHSpin2)
   ON_COMMAND(IDBN_HSPIN3,OnHSpin3)
   ON_COMMAND(IDBN_HSPIN4,OnHSpin4)
   ON_COMMAND(IDBN_HSPIN5,OnHSpin5)
   ON_COMMAND(IDBN_HSPIN6,OnHSpin6)
   ON_COMMAND(IDBN_NFTSW,OnNFTSw)
   ON_COMMAND(IDBN_SWITCH1,OnSwitch1)
   ON_COMMAND(IDBN_REDBUTTON,OnRedBut)
   ON_COMMAND(IDBN_GRNBUTTON,OnGrnBut)
   ON_COMMAND(IDBN_BLUBUTTON,OnBluBut)
   ON_COMMAND(IDBN_YELBUTTON,OnYelBut)
   ON_COMMAND(IDBN_CYNBUTTON,OnCynBut)
   ON_COMMAND(IDBN_MAGBUTTON,OnMagBut)
   ON_COMMAND(IDBN_GRYBUTTON,OnGryBut)
   ON_COMMAND(IDBN_BLKBUTTON,OnBlkBut)
   ON_COMMAND(IDBN_VOLUME,OnVolume)
   ON_COMMAND(IDBN_VOLED,OnVoled)
   ON_WM_PAINT()   
   ON_WM_CREATE()
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

//**** End Message Map ******************************************************

//***************************************************************************
//
//  Main Window WM_CREATE Message Handler
//
//***************************************************************************
int CMainWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{


   // One note to make here, is that the last 3 parms in the Create
   // functions must be type cast to UINT when programming with MFC
   // style programming. 

   // Create Spin Button on the Main windlow client area.
   // This will be vertical, using the size 1 predefined bitmaps.
   m_VSpin1.Create(
      BTN_VERT | BTN_SPIN1,         // Vertical size 1 
      0,0,0,0,                      // No User Bitmap
      20,10,                        // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      150,10,                       // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_VSPIN1,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_VSPEdit1.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(35,10,67,32),     // Position and Size(35,10,32,22)
      this,                   // Parent window
      IDED_VSPEDIT1);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin1.GetVal());
   m_VSPEdit1.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be vertical, using the size 2 predefined bitmaps.
   m_VSpin2.Create(
      BTN_VERT | BTN_SPIN2,         // Vertical size 2
      0,0,0,0,                      // No User Bitmap
      18,40,                        // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      150,10,                       // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_VSPIN2,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_VSPEdit2.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(35,40,67,62),     // Position and Size(35,40,32,22)
      this,                   // Parent window
      IDED_VSPEDIT2);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin2.GetVal());
   m_VSPEdit2.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be vertical, using the size 3 predefined bitmaps.
   m_VSpin3.Create(
      BTN_VERT | BTN_SPIN3,         // Vertical size 3
      0,0,0,0,                      // No User Bitmap
      16,70,                        // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      150,10,                       // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_VSPIN3,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_VSPEdit3.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(35,70,67,92),     // Position and Size(35,70,32,22)
      this,                   // Parent window
      IDED_VSPEDIT3);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin3.GetVal());
   m_VSPEdit3.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be vertical, using the size 4 predefined bitmaps.
   m_VSpin4.Create(
      BTN_VERT | BTN_SPIN4,         // Vertical size 4
      0,0,0,0,                      // No User Bitmap
      14,100,                       // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      150,10,                       // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_VSPIN4,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_VSPEdit4.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(35,100,67,122),   // Position and Size(35,100,32,22)
      this,                   // Parent window
      IDED_VSPEDIT4);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin4.GetVal());
   m_VSPEdit4.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be vertical, using the size 5 predefined bitmaps.
   m_VSpin5.Create(
      BTN_VERT | BTN_SPIN5,         // Vertical size 5
      0,0,0,0,                      // No User Bitmap
      12,130,                       // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      150,10,                       // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_VSPIN5,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_VSPEdit5.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(35,130,67,152),   // Position and Size(35,130,32,22)
      this,                   // Parent window
      IDED_VSPEDIT5);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin5.GetVal());
   m_VSPEdit5.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be vertical, using the size 6 predefined bitmaps.
   m_VSpin6.Create(
      BTN_VERT | BTN_SPIN5,         // Vertical size 6
      0,0,0,0,                      // No User Bitmap
      10,160,                       // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      150,10,                       // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_VSPIN6,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_VSPEdit6.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(35,160,67,182),   // Position and Size(35,160,32,22)
      this,                   // Parent window
      IDED_VSPEDIT6);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin6.GetVal());
   m_VSPEdit6.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be horizontal, using the size 1 predefined bitmaps.
   m_HSpin1.Create(
      BTN_SPIN1 | BTN_WRAP,         // Horizontal size 1
      0,0,0,0,                      // No User Bitmap
      95,10,                        // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      500,150,                      // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_HSPIN1,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_HSPEdit1.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(115,10,147,32),   // Position and Size(115,10,32,22)
      this,                   // Parent window
      IDED_HSPEDIT1);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin1.GetVal());
   m_HSPEdit1.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be horizontal, using the size 2 predefined bitmaps.
   m_HSpin2.Create(
      BTN_SPIN2 | BTN_WRAP,         // Horizontal size 2
      0,0,0,0,                      // No User Bitmap
      93,40,                        // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      500,150,                      // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_HSPIN2,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_HSPEdit2.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(115,40,147,62),   // Position and Size(115,40,32,22)
      this,                   // Parent window
      IDED_HSPEDIT2);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin2.GetVal());
   m_HSPEdit2.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be horizontal, using the size 3 predefined bitmaps.
   m_HSpin3.Create(
      BTN_SPIN3 | BTN_WRAP,         // Horizontal size 3
      0,0,0,0,                      // No User Bitmap
      91,70,                        // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      500,150,                      // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_HSPIN3,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_HSPEdit3.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(115,70,147,92),   // Position and Size(115,70,32,22)
      this,                   // Parent window
      IDED_HSPEDIT3);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin3.GetVal());
   m_HSPEdit3.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be horizontal, using the size 4 predefined bitmaps.
   m_HSpin4.Create(
      BTN_SPIN4 | BTN_WRAP,         // Horizontal size 4
      0,0,0,0,                      // No User Bitmap
      89,100,                       // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      500,150,                      // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_HSPIN4,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_HSPEdit4.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(115,100,147,122), // Position and Size(115,100,32,22)
      this,                   // Parent window
      IDED_HSPEDIT4);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin4.GetVal());
   m_HSPEdit4.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be horizontal, using the size 5 predefined bitmaps.
   m_HSpin5.Create(
      BTN_SPIN5 | BTN_WRAP,         // Horizontal size 5
      0,0,0,0,                      // No User Bitmap
      87,130,                       // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      500,150,                      // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_HSPIN5,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_HSPEdit5.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(115,130,147,152), // Position and Size(115,130,32,22)
      this,                   // Parent window
      IDED_HSPEDIT5);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin5.GetVal());
   m_HSPEdit5.SetWindowText(cBuff);

   // Create Spin Button on the Main windlow client area.
   // This will be horizontal, using the size 6 predefined bitmaps.
   m_HSpin6.Create(
      BTN_SPIN6 | BTN_WRAP,         // Horizontal size 6
      0,0,0,0,                      // No User Bitmap
      85,160,                       // Spin button position
      0,0,                          // Spin button size (use defaults)
      1,                            // Step value
      0,100,                        // range
      50,                           // Initial value
      500,150,                      // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_HSPIN6,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // EDIT control to display the above Spin Button value
   m_HSPEdit6.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(115,160,147,182), // Position and Size(115,160,32,22)
      this,                   // Parent window
      IDED_HSPEDIT6);         // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin6.GetVal());
   m_HSPEdit6.SetWindowText(cBuff);

   // This is a 2-State Toggle Switch located directly beneath the
   // 6 vertical spin button.  It is used as a switch to enable and
   // disable the vertical spin buttons.
   m_NFTSw.Create(
      BTN_T2S,                      // 2-State Toggle Button Type
      (LPSTR)IDB_NFTLO,             // Bitmap name for state 1 position
      (LPSTR)IDB_NFTHI,             // Bitmap name for state 2 position
      (LPSTR)IDB_NFTLOG,            // Bitmap name for disabled state 1 position
      (LPSTR)IDB_NFTHIG,            // Bitmap name for disabled state 2 position
      15,200,                       // Button position
      0,0,                          // Button size (use bitmap size)
      1,                            // Step value
      0,1,                          // Range
      1,                            // Initial value
      1,1,                          // Delay, Speed  (Ingore by this type anyway)
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_NFTSW,             // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // This User defined Spin Button used to look simulate a 2-State
   // Momentary Toggle Switch located directly beneath the 6 horizontal
   // Spin buttons.  It is used as a switch to enable and
   // disable the horizontal spin buttons.
   m_Switch1.Create(
      BTN_SPINU,                    // User defined Spin Button Type
      (LPSTR)IDB_SWITCH1,           // Bitmap name for Unpushed State
      (LPSTR)IDB_SWITCH1N,          // Bitmap name for Incrementing State
      (LPSTR)IDB_SWITCH1F,          // Bitmap name for Decrementing State
      0,                            // No Bitmap for Disabled State
      90,200,                       // Button position
      0,0,                          // Button size (use bitmap size)
      1,                            // Step value
      0,1,                          // Range
      1,                            // Initial value
      1,1,                          // Delay, Speed
      FALSE,                        // Use Arrow Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_SWITCH1,           // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // Create a Red Color Button on the Main windlow client area.
   m_RedBut.Create(
      BTN_RED,                      // Red Color Button Type
      0,0,0,0,                      // No Bitmaps
      180,10,                       // Button position
      15,15,                        // Button size
      0,                            // No Step Value
      0,0,                          // No Range
      0,                            // No Initial value
      1,1,                          // Delay, Speed  (Ingore by this type anyway)
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      IDBN_REDBUTTON,               // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // Create a Green Color Button on the Main windlow client area.
   m_GrnBut.Create(
      BTN_GRN,                      // Green Color Button Type
      0,0,0,0,                      // No Bitmaps
      205,10,                       // Button position
      15,15,                        // Button size
      0,                            // No Step Value
      0,0,                          // No Range
      0,                            // No Initial value
      1,1,                          // Delay, Speed  (Ingore by this type anyway)
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      IDBN_GRNBUTTON,               // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // Create a Blue Color Button on the Main windlow client area.
   m_BluBut.Create(
      BTN_BLU,                      // Blue Color Button Type
      0,0,0,0,                      // No Bitmaps
      230,10,                       // Button position
      15,15,                        // Button size
      0,                            // No Step Value
      0,0,                          // No Range
      0,                            // No Initial value
      1,1,                          // Delay, Speed  (Ingore by this type anyway)
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      IDBN_BLUBUTTON,               // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // Create a Yellow Color Button on the Main windlow client area.
   m_YelBut.Create(
      BTN_YEL,                      // Yellow Color Button Type
      0,0,0,0,                      // No Bitmaps
      255,10,                       // Button position
      15,15,                        // Button size
      0,                            // No Step Value
      0,0,                          // No Range
      0,                            // No Initial value
      1,1,                          // Delay, Speed  (Ingore by this type anyway)
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      IDBN_YELBUTTON,               // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // Create a Cyan Color Button on the Main windlow client area.
   m_CynBut.Create(
      BTN_CYN,                      // Cyan Color Button Type
      0,0,0,0,                      // No Bitmaps
      280,10,                       // Button position
      15,15,                        // Button size
      0,                            // No Step Value
      0,0,                          // No Range
      0,                            // No Initial value
      1,1,                          // Delay, Speed  (Ingore by this type anyway)
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      IDBN_CYNBUTTON,               // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // Create a Magenta Color Button on the Main windlow client area.
   m_MagBut.Create(
      BTN_MAG,                      // Magenta Color Button Type
      0,0,0,0,                      // No Bitmaps
      305,10,                       // Button position
      15,15,                        // Button size
      0,                            // No Step Value
      0,0,                          // No Range
      0,                            // No Initial value
      1,1,                          // Delay, Speed  (Ingore by this type anyway)
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      IDBN_MAGBUTTON,               // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // Create a Gray Color Button on the Main windlow client area.
   m_GryBut.Create(
      BTN_GRY,                      // Gray Color Button Type
      0,0,0,0,                      // No Bitmaps
      330,10,                       // Button position
      15,15,                        // Button size
      0,                            // No Step Value
      0,0,                          // No Range
      0,                            // No Initial value
      1,1,                          // Delay, Speed  (Ingore by this type anyway)
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_GRYBUTTON,         // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // Create a Black Color Button on the Main windlow client area.
   m_BlkBut.Create(
      BTN_BLK,                      // Black Color Button Type
      0,0,0,0,                      // No Bitmaps
      355,10,                       // Button position
      15,15,                        // Button size
      0,                            // No Step Value
      0,0,                          // No Range
      0,                            // No Initial value
      1,1,                          // Delay, Speed  (Ingore by this type anyway)
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      IDBN_BLKBUTTON,               // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // Create Spin Button for the fancy looking Volume Control
   m_Volume.Create(
      BTN_SPINU,                    // User defined Spin Button Type
      (LPSTR)IDB_VOLUME,            // Bitmap name for Unpushed State
      (LPSTR)IDB_VOLUMEI,           // Bitmap name for Incrementing State
      (LPSTR)IDB_VOLUMED,           // Bitmap name for Decrementing State
      (LPSTR)IDB_VOLUMEG,           // Bitmap name for Disabled State
      200,100,                      // Button position
      0,0,                          // Button size (use bitmap size)
      1,                            // Step value
      0,100,                        // Range
      0,                            // Initial value
      200,100,                      // Delay, Speed
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_VOLUME,            // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   // Create EDIT control to display the above Spin Button value
   m_VEdit.Create(
      WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
      CRect(200,77,247,99),    // Position and Size(200,77,47,22)
      this,                   // Parent window
      IDED_VEDIT);            // ID

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_Volume.GetVal());
   m_VEdit.SetWindowText(cBuff);

   // Create 2-State Push Button That will enable and disable
   // the fancy looking Volume Control
   m_Voled.Create(
      BTN_P2S,                      // 2-State Push Button Type
      (LPSTR)IDB_VOLD,              // Bitmap name for Unpushed State 1
      (LPSTR)IDB_VOLE,              // Bitmap name for Unpushed State 2
      (LPSTR)IDB_VOLP,              // Bitmap name for Pushed State      
      "0",                          // No Bitmap for Disabled State
      200,121,                      // Button position
      0,0,                          // Button size (use bitmap size)
      1,                            // Step value
      0,1,                          // Range
      1,                            // Initial value
      1,1,                          // Delay, Speed  (Ingore by this type anyway)
      TRUE,                         // Use Hand Cursor
      (UINT)m_hWnd,                 // Parent window handle
      (UINT)IDBN_VOLED,             // ID Value
      (UINT)AfxGetInstanceHandle()  // Program instance
   );

   return 0;

}  // END WM_CREATE

//***************************************************************************
//
//  Main Window WM_COMMAMD:ID_ABOUT Command Message Handler
//
//***************************************************************************
void CMainWnd::OnAbout()
{

   CDialog about(IDD_ABOUTBOX);
   about.DoModal();

} // End CMainWnd::OnAbout

//***************************************************************************
//
//  Main Window WM_COMMAMD:VSPIN1 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnVSpin1()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin1.GetVal());
   m_VSPEdit1.SetWindowText(cBuff);
   m_VSPEdit1.UpdateWindow();

} // End CMainWnd::OnVSpin1

//***************************************************************************
//
//  Main Window WM_COMMAMD:VSPIN2 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnVSpin2()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin2.GetVal());
   m_VSPEdit2.SetWindowText(cBuff);
   m_VSPEdit2.UpdateWindow();

} // End CMainWnd::OnVSpin2

//***************************************************************************
//
//  Main Window WM_COMMAMD:VSPIN3 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnVSpin3()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin3.GetVal());
   m_VSPEdit3.SetWindowText(cBuff);
   m_VSPEdit3.UpdateWindow();

} // End CMainWnd::OnVSpin3

//***************************************************************************
//
//  Main Window WM_COMMAMD:VSPIN4 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnVSpin4()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin4.GetVal());
   m_VSPEdit4.SetWindowText(cBuff);
   m_VSPEdit4.UpdateWindow();

} // End CMainWnd::OnVSpin4

//***************************************************************************
//
//  Main Window WM_COMMAMD:VSPIN5 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnVSpin5()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin5.GetVal());
   m_VSPEdit5.SetWindowText(cBuff);
   m_VSPEdit5.UpdateWindow();

} // End CMainWnd::OnVSpin5

//***************************************************************************
//
//  Main Window WM_COMMAMD:VSPIN6 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnVSpin6()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_VSpin6.GetVal());
   m_VSPEdit6.SetWindowText(cBuff);
   m_VSPEdit6.UpdateWindow();

} // End CMainWnd::OnVSpin6

//***************************************************************************
//
//  Main Window WM_COMMAMD:HSPIN1 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnHSpin1()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin1.GetVal());
   m_HSPEdit1.SetWindowText(cBuff);
   m_HSPEdit1.UpdateWindow();

} // End CMainWnd::OnHSpin1

//***************************************************************************
//
//  Main Window WM_COMMAMD:HSPIN2 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnHSpin2()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin2.GetVal());
   m_HSPEdit2.SetWindowText(cBuff);
   m_HSPEdit2.UpdateWindow();

} // End CMainWnd::OnHSpin2

//***************************************************************************
//
//  Main Window WM_COMMAMD:HSPIN3 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnHSpin3()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin3.GetVal());
   m_HSPEdit3.SetWindowText(cBuff);
   m_HSPEdit3.UpdateWindow();

} // End CMainWnd::OnHSpin3

//***************************************************************************
//
//  Main Window WM_COMMAMD:HSPIN4 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnHSpin4()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin4.GetVal());
   m_HSPEdit4.SetWindowText(cBuff);
   m_HSPEdit4.UpdateWindow();

} // End CMainWnd::OnHSpin4

//***************************************************************************
//
//  Main Window WM_COMMAMD:HSPIN5 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnHSpin5()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin5.GetVal());
   m_HSPEdit5.SetWindowText(cBuff);
   m_HSPEdit5.UpdateWindow();

} // End CMainWnd::OnHSpin5

//***************************************************************************
//
//  Main Window WM_COMMAMD:HSPIN6 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnHSpin6()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_HSpin6.GetVal());
   m_HSPEdit6.SetWindowText(cBuff);
   m_HSPEdit6.UpdateWindow();

} // End CMainWnd::OnHSpin6

//***************************************************************************
//
//  Main Window WM_COMMAMD:NFTSW Command Message Handler
//
//***************************************************************************
void CMainWnd::OnNFTSw()
{

   // 2-State Toggle Switch that disables and disables the 
   // vertical spin buttons.
   if (m_NFTSw.GetVal())  // Enable Vertical Spin Buttons
   {
      m_VSpin1.Enable(TRUE);
      m_VSpin2.Enable(TRUE);
      m_VSpin3.Enable(TRUE);
      m_VSpin4.Enable(TRUE);
      m_VSpin5.Enable(TRUE);
      m_VSpin6.Enable(TRUE);
   }
   else   // Disable Vertical Spin Buttons
   {
      m_VSpin1.Enable(FALSE);
      m_VSpin2.Enable(FALSE);
      m_VSpin3.Enable(FALSE);
      m_VSpin4.Enable(FALSE);
      m_VSpin5.Enable(FALSE);
      m_VSpin6.Enable(FALSE);
   }
 
} // End CMainWnd::OnNFTSw

//***************************************************************************
//
//  Main Window WM_COMMAMD:SWITCH1 Command Message Handler
//
//***************************************************************************
void CMainWnd::OnSwitch1()
{

   // Spin Button that similates a 2-State Momentary Toggle Switch that
   // disables and disables the horizontal spin buttons.
   if (m_Switch1.GetVal())  // Enable Horizontal Spin Buttons
   {
      m_HSpin1.Enable(TRUE);
      m_HSpin2.Enable(TRUE);
      m_HSpin3.Enable(TRUE);
      m_HSpin4.Enable(TRUE);
      m_HSpin5.Enable(TRUE);
      m_HSpin6.Enable(TRUE);
   }
   else   // Disable Horizontal Spin Buttons
   {
      m_HSpin1.Enable(FALSE);
      m_HSpin2.Enable(FALSE);
      m_HSpin3.Enable(FALSE);
      m_HSpin4.Enable(FALSE);
      m_HSpin5.Enable(FALSE);
      m_HSpin6.Enable(FALSE);
   }

} // End CMainWnd::OnSwitch1

//***************************************************************************
//
//  Main Window WM_COMMAMD:REDBUTTON Command Message Handler
//
//***************************************************************************
void CMainWnd::OnRedBut()
{

   TextColor = RGB(255,0,0);
   InvalidateRect(NULL,FALSE);

} // End CMainWnd::OnRedBut

//***************************************************************************
//
//  Main Window WM_COMMAMD:GRNBUTTON Command Message Handler
//
//***************************************************************************
void CMainWnd::OnGrnBut()
{

   TextColor = RGB(0,255,0);
   InvalidateRect(NULL,FALSE);

} // End CMainWnd::OnGrnBut

//***************************************************************************
//
//  Main Window WM_COMMAMD:BLUBUTTON Command Message Handler
//
//***************************************************************************
void CMainWnd::OnBluBut()
{

   TextColor = RGB(0,0,255);
   InvalidateRect(NULL,FALSE);

} // End CMainWnd::OnBluBut

//***************************************************************************
//
//  Main Window WM_COMMAMD:YELBUTTON Command Message Handler
//
//***************************************************************************
void CMainWnd::OnYelBut()
{

   TextColor = RGB(255,255,0);
   InvalidateRect(NULL,FALSE);

} // End CMainWnd::OnYelBut

//***************************************************************************
//
//  Main Window WM_COMMAMD:CYNBUTTON Command Message Handler
//
//***************************************************************************
void CMainWnd::OnCynBut()
{

   TextColor = RGB(0,255,255);
   InvalidateRect(NULL,FALSE);

} // End CMainWnd::OnCynBut

//***************************************************************************
//
//  Main Window WM_COMMAMD:MAGBUTTON Command Message Handler
//
//***************************************************************************
void CMainWnd::OnMagBut()
{

   TextColor = RGB(255,0,255);
   InvalidateRect(NULL,FALSE);

} // End CMainWnd::OnMagBut

//***************************************************************************
//
//  Main Window WM_COMMAMD:GRYBUTTON Command Message Handler
//
//***************************************************************************
void CMainWnd::OnGryBut()
{

   TextColor = RGB(128,128,128);
   InvalidateRect(NULL,FALSE);

} // End CMainWnd::OnGryBut

//***************************************************************************
//
//  Main Window WM_COMMAMD:BLKBUTTON Command Message Handler
//
//***************************************************************************
void CMainWnd::OnBlkBut()
{

   TextColor = RGB(0,0,0);
   InvalidateRect(NULL,FALSE);

} // End CMainWnd::OnBlkBut

//***************************************************************************
//
//  Main Window WM_COMMAMD:VOLUME Command Message Handler
//
//***************************************************************************
void CMainWnd::OnVolume()
{

   wsprintf((LPSTR)cBuff.GetBuffer(9),"%d",m_Volume.GetVal());
   m_VEdit.SetWindowText(cBuff);
   m_VEdit.UpdateWindow();

} // End CMainWnd::OnVolume

//***************************************************************************
//
//  Main Window WM_COMMAMD:VOLED Command Message Handler
//
//***************************************************************************
void CMainWnd::OnVoled()
{

   if (m_Voled.GetVal())
      m_Volume.Enable(TRUE);
   else
      m_Volume.Enable(FALSE);

} // End CMainWnd::OnVoled

//***************************************************************************
//
//  Main Window WM_COMMAMD:PAINT Command Message Handler
//
//***************************************************************************
void CMainWnd::OnPaint()
{

   CPaintDC dc(this);
   
   dc.SetBkColor(RGB(192,192,192));
   dc.SetTextColor(TextColor);
   dc.TextOut(160,30,"Change Text Color With Color Button",35);

} // End CMainWnd::OnPaint

//**** End Application's Main Window Class Implementation *******************
//***************************************************************************
//***************************************************************************

//***************************************************************************
//***************************************************************************
// Begin Application Execution
//***************************************************************************
//***************************************************************************

//***************************************************************************
//
//  Global Data
//
//***************************************************************************

// By declaring a global application object, the whole application runs
CTheApp NEAR theApp;
